$Id: README.md 11545 2026-01-19 07:08:04Z cfrees $

# forest-ext

Small extensions for Sašo Živanović's fantastic Forest package.

Currently the package provides the following Forest libraries:
- ext.ling      (simple wrapper styles)
- ext.multi     (children with multiple parents)
- ext.tagging   (produce tagged PDF)
- ext.utils     (minor tweaks)

Debugging versions of all libraries are provided.

## Licence

Copyright 2025-2026 Clea F. Rees

This work may be distributed and/or modified under the
conditions of the LaTeX Project Public License, either version 1.3c
of this license or (at your option) any later version.
The latest version of this license is in
https://www.latex-project.org/lppl.txt
and version 1.3c or later is part of all distributions of LaTeX
version 2008-05-04 or later.

This work has the LPPL maintenance status `maintained'.

The Current Maintainer of this work is Clea F. Rees.

This file may only be distributed together with a copy of the package
chronos. You may however distribute the package chronos without
such generated files.

This work consists of all files listed in manifest.txt.

## Features

Forest is incompatible with the LaTeX Project's code for producing tagged PDF.
`ext.tagging` enables Forest trees to be included in tagged documents by
auto-generating alternative text based on the content of trees' nodes and edge
labels. The result can be configured using Forest options and registers and/or
providing custom plugs for the provided sockets.

I find myself using certain style tweaks repeatedly in both my own documents
and answers on TeX SE. A few of these are provided here for convenience:
- align parent with the middle child, if the parent has an odd number of
children;
- add labels for levels or tiers at the edge of the tree;
- include children with multiple parents;
- 'pretty nice empty nodes' (for linguists).

## Limitations

The tagging code, in particular, is far from being a panacea. Known limitations
include the following.

The bounding box calculation is based on the size of the tree. In the best
case, this will be _almost_ but not quite correct. In such cases, I assume the
dimensions should be perfectly satisfactory. However, in the worst case, the 
dimensions will be _very_ wrong. If the code is otherwise useful, I will look
into the possibility of calculating the dimensions at a later point. (Right now,
the problem is that they are calculated too early and so do not account for
additions in `tikz` keys, for instance.) 

Trees are tagged with `alt` text or nothing. No other options are available. In
particular, none of `text`, `actualtext` and `artifact` (all supported by
`latex-lab` for TikZ) are provided. It would be easy to support `artifact` and
`actualtext`, but I doubt these are useful for trees.

**Content is provided as simple text. Mathematics, logic and other symbolic
markup is NOT rendered into luamml, xml or html. No associated files are 
written or embedded.** It is, to say the least, unclear how content of this 
kind should be tagged. `alt` text is almost certainly a poor substitute, but
there is not currently any obvious way to improve this.

It would be relatively straightforward to write a structured xml or similar to
represent the tree. Unfortunately, I don't believe anything is available to 
make use of such a file. Individual formulae could be marked up as luamml, but
in the absence of some standard way to represent the _structure_ of the tree,
this does not seem especially useful. 

A hybrid consisting of `alt` text with luamml components might work for maths
and, possibly, logic and linguistics, but that seems alien to the framework in
the PDF specification. `alt` text is designed, as far as I can tell, for
pictures. Trying to fit linguistic analyses or formal proofs into that space is
unlikely to yield satisfactory results. 

But these limitations are imposed by the various technical specifications and 
far beyond the control of any package. 

(Possibly trees could be mapped to a specialised structure in the tagged
content, which is, after all, itself arranged as a tree. But I am not certain 
whether a structure of that kind is possible within the tagging framework 
generated by the LaTeX format or if it is even permissible according to the
somewhat complex specifications for accessible PDF. If that was possible,
symbolic content might then be marked up as such, without disconnecting it from
the structure.)

## Code Repositories

Code for the package is hosted at 
  https://codeberg.org/cfr/prooftrees
For convenience, the repository will be mirrored at
  https://github.com/cfr42/prooftrees

## Contact Details

Bug reports, feature requests etc. should be filed at
  https://codeberg.org/cfr/prooftrees/issues


Clea F. Rees
Version 0.2
2026-01-19

vim: et:tw=80:ts=2:
